// config: norepeat

#include "GetObject.js"
#include "GetPoint.js"

function DoIsocurve()
{
	var objectpicker = moi.ui.createObjectPicker();
	
	objectpicker.allowFaces();
	if ( !GetObject( objectpicker ) )
		return;
		
	var face = objectpicker.objects.item(0);
	face.selected = false;
	face.getParentBRep().selected = false;
	
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.hideUI( 'done' );
	moi.ui.showUI( 'PickPointPrompt' );
	moi.ui.showUI( 'options' );
	moi.ui.endUIUpdate();

	var pointpicker = moi.ui.createPointPicker();
	pointpicker.restrictToObject( face );
	
	var first = true;
	var factory = false;
	
	while ( 1 )
	{
		if ( !factory )
		{
			factory = moi.command.createFactory( 'isocurve' );
			moi.ui.bindUIToInput( 'dir', 'value', factory.getInput(2) );
			factory.setInput( 0, face );
		
			pointpicker.clearBindings();
			pointpicker.bindResultPt( factory.getInput(1) );
		}
		
		if ( !pointpicker.waitForEvent() || pointpicker.event == 'done' )
		{
			factory.cancel();
			return;
		}
			
		if ( pointpicker.event == 'finished' )
		{
			factory.commit();
			factory = false;
			
			if ( first )
			{
				moi.ui.beginUIUpdate();
				moi.ui.showUI( 'done' );
				moi.ui.endUIUpdate();
				first = false;
			}
		}
	}
}

DoIsocurve();
